/**************************************************************************************
 Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.
***************************************************************************************
$Id: Slmp_ErrorCodes.h 74927 2018-03-28 08:05:34Z Sven $:


Changes:
 Date          Description
 -----------------------------------------------------------------------------------
 yyyy-mm-dd    created
**************************************************************************************/

#ifndef SLMP_ERRORCODES_H_INCLUDED
#define SLMP_ERRORCODES_H_INCLUDED

#include <stdint.h>

#ifndef SLMP_ERROR_TABLE_BEGIN
#define SLMP_ERROR_TABLE_BEGIN typedef enum SLMP_ERROR_CODE_Etag {
#endif

#ifndef SLMP_ERROR_RESULT
#define SLMP_ERROR_RESULT(x, v) x = v,
#endif

#ifndef SLMP_ERROR_TABLE_END
#define SLMP_ERROR_TABLE_END SLMP_ERROR_CODE_VALUE_RANGE = 0xFFFFFFFF } SLMP_ERROR_CODE_E;
#endif

SLMP_ERROR_TABLE_BEGIN
#ifndef SLMP_ERROR_TABLE_EXCLUDE_COMMON_ERRORS
SLMP_ERROR_RESULT(SLMP_SUCCESS, 0)

SLMP_ERROR_RESULT(SLMP_ERROR_FAIL, 0xC0000001)
SLMP_ERROR_RESULT(SLMP_ERROR_UNEXPECTED, 0xC0000002)
SLMP_ERROR_RESULT(SLMP_ERROR_OUT_OF_MEMORY, 0xC0000003)
SLMP_ERROR_RESULT(SLMP_ERROR_UNKNOWN_COMMAND, 0xC0000004)
SLMP_ERROR_RESULT(SLMP_ERROR_INVALID_PARAMETER, 0xC0000009)
SLMP_ERROR_RESULT(SLMP_ERROR_WATCHDOG_TIMEOUT, 0xC000000C)
SLMP_ERROR_RESULT(SLMP_ERROR_INVALID_SEQUENCE, 0xC000000F)
SLMP_ERROR_RESULT(SLMP_ERROR_REQUEST_RUNNING, 0xC000001A)
SLMP_ERROR_RESULT(SLMP_ERROR_NOT_CONFIGURED, 0xC0000119)
SLMP_ERROR_RESULT(SLMP_ERROR_CONFIGURATION_FAULT, 0xC0000120)
SLMP_ERROR_RESULT(SLMP_ERROR_INSUFFICIENT_LICENSE, 0xC0000123)
SLMP_ERROR_RESULT(SLMP_ERROR_PARAMETER_ERROR, 0xC0000124)
SLMP_ERROR_RESULT(SLMP_ERROR_NETWORK_FAULT, 0xC0000140)
SLMP_ERROR_RESULT(SLMP_ERROR_CONNECTION_TIMEOUT, 0xC0000142)
SLMP_ERROR_RESULT(SLMP_ERROR_CABLE_DISCONNECT, 0xC0000145)
SLMP_ERROR_RESULT(SLMP_ERROR_BUS_OFF, 0xC0000180)
SLMP_ERROR_RESULT(SLMP_ERROR_CONFIG_IS_LOCKED, 0xC0000181)
SLMP_ERROR_RESULT(SLMP_ERROR_APPLICATION_ALREADY_REGISTERED, 0xC0000201)
SLMP_ERROR_RESULT(SLMP_ERROR_NO_APPLICATION_REGISTERED, 0xC0000202)
#endif

/* HIL_COMPONENT_ID_SLMP                  =  257:HIL_COMPONENT_ID_SLMP */
SLMP_ERROR_RESULT(SLMP_SUCCESS_NO_RESPONSE_RETURN, 0x01010001) /* special success code to skip sending of response */
SLMP_ERROR_RESULT(SLMP_SUCCESS_END_OF_BROADCAST, 0x01010002) /* special success code to signal end of broadcast receive */

SLMP_ERROR_RESULT(SLMP_ERROR_REQUEST_DESTINATION_PROBLEM, 0xC1010001)
SLMP_ERROR_RESULT(SLMP_ERROR_PROTOCOL_AND_PORT_ALREADY_IN_USE, 0xC1010002)
SLMP_ERROR_RESULT(SLMP_ERROR_COULD_NOT_INIT_SOCKET, 0xC1010003)
SLMP_ERROR_RESULT(SLMP_ERROR_INVALID_CONNECTION, 0xC1010004)
SLMP_ERROR_RESULT(SLMP_ERROR_INVALID_INDICATION_HANDLE, 0xC1010005)
SLMP_ERROR_RESULT(SLMP_ERROR_CMD_SUBCMD_ALREADY_REGISTERED, 0xC1010006)
SLMP_ERROR_RESULT(SLMP_ERROR_UNSUPPORTED_PARAMETERS, 0xC1010007)
SLMP_ERROR_RESULT(SLMP_ERROR_REQUEST_TOO_LONG, 0xC1010008)
SLMP_ERROR_RESULT(SLMP_ERROR_REQUEST_COULD_NOT_BE_SENT, 0xC1010009)
SLMP_ERROR_RESULT(SLMP_ERROR_REQUEST_PROTOCOL_NOT_ENABLED, 0xC101000A)
SLMP_ERROR_RESULT(SLMP_ERROR_INVALID_REQUEST_TYPE, 0xC101000B)
SLMP_ERROR_RESULT(SLMP_ERROR_INVALID_RESPONSE_RECEIVED, 0xC101000C)
SLMP_ERROR_RESULT(SLMP_ERROR_REQUEST_TIMEOUT, 0xC101000D)
SLMP_ERROR_RESULT(SLMP_ERROR_OUT_OF_PBUF_MEM, 0xC101000E)

#ifndef SLMP_EXCLUDE_ENDCODES
/* HIL_COMPONENT_ID_SLMP_ENDCODE          =  0xF6:HIL_COMPONENT_ID_SLMP_ENDCODE */
#ifndef SLMP_EXCLUDE_MAPPING_AREA_DEFINES
SLMP_ERROR_RESULT(SLMP_ERROR_ENDCODE_MAPPING_START, 0xC0F60000)
#endif
SLMP_ERROR_RESULT(SLMP_ERROR_ENDCODE_CMD_SUBCMD_ERROR, 0xC0F6C059)
SLMP_ERROR_RESULT(SLMP_ERROR_ENDCODE_ERROR_IN_REQ_MESSAGE, 0xC0F6C05C)
SLMP_ERROR_RESULT(SLMP_ERROR_ENDCODE_REQ_LENGTH_DOES_NOT_MATCH, 0xC0F6C061)
SLMP_ERROR_RESULT(SLMP_ERROR_ENDCODE_BUSY, 0xC0F6CEE0)
SLMP_ERROR_RESULT(SLMP_ERROR_ENDCODE_REQUEST_SIZE_EXCEEDED_EFFECTIVE_PROCESSING_RANGE, 0xC0F6CEE1)
SLMP_ERROR_RESULT(SLMP_ERROR_ENDCODE_RESPONSE_SIZE_EXCEEDED_EFFECTIVE_PROCESSING_RANGE, 0xC0F6CEE2)
SLMP_ERROR_RESULT(SLMP_ERROR_ENDCODE_SPECIFIED_SERVER_INFO_NUMBER_DOES_NOT_EXIST, 0xC0F6CF10)
SLMP_ERROR_RESULT(SLMP_ERROR_ENDCODE_CONTAINED_ITEMS_CANNOT_BE_SET, 0xC0F6CF20)
SLMP_ERROR_RESULT(SLMP_ERROR_ENDCODE_PARAMETER_ID_DOES_NOT_EXIST, 0xC0F6CF30)
SLMP_ERROR_RESULT(SLMP_ERROR_ENDCODE_WRITE_EXCLUSIVE_START_NOT_PERFORMED, 0xC0F6CF31)
SLMP_ERROR_RESULT(SLMP_ERROR_ENDCODE_RELAY_PATH_DESTINATION_COMM_ERROR, 0xC0F6CF70)
SLMP_ERROR_RESULT(SLMP_ERROR_ENDCODE_TIMEOUT_OCCURED, 0xC0F6CF71)
#ifndef SLMP_EXCLUDE_MAPPING_AREA_DEFINES
SLMP_ERROR_RESULT(SLMP_ERROR_ENDCODE_MAPPING_END, 0xC0F6FFFF)
#endif
#endif

SLMP_ERROR_TABLE_END

#endif
